@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')
    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '9'])
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 10vh;align-items: center">
                        <div class="col-6" style="padding-right: 0px;">
                        </div>
                        <div class="col-6 float-right">
{{--                            <form method="GET" action="{{ Route("sender_mail") }}">--}}
{{--                                <div class="col-12" style="text-align: center">--}}
{{--                                    <input  class="btn btn-outline-dark float-right" style="font-size:16px;text-align: center" type="submit" value="測試寄信" >--}}
{{--                                </div>--}}
{{--                            </form>--}}
                        </div>
                    </div>
                    {{--表格呈現-須審核假單列表--}}
                    <table class="table table-striped table-bordered table-hover" id="tableL01"  style="height: 75vh"></table>
                </div>

            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{-- 查看假單彈出視窗 --}}
    <div class="modal fade" id="CheckLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">確認請假資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body row">
                    <div class="col-12">
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="name" >姓名</label>
                            <div class="col-6">
                                <input id='name' name="name" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="category" >假別</label>
                            <div class="col-6">
                                <input id='category' name="category" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="reason" >原因</label>
                            <div class="col-6">
                                <input id='reason' name="reason" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="start" >開始時間</label>
                            <div class="col-6">
                                <input id='start' name="start" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="end" >結束時間</label>
                            <div class="col-6">
                                <input id='end' name="end" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-sm-3 col-form-label" for="leave_time" >請假時長</label>
                            <div class="col-6">
                                <input id='leave_time' name="leave_time" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="leave_created" >申請日期</label>
                            <div class="col-6">
                                <input id='leave_created' name="leave_created" style="text-align: center"  type="text" class="form-control" readonly >
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">確定</button>
                </div>
            </div>
        </div>
    </div>
    {{-- 不同意彈出視窗 --}}
    <div class="modal fade" id="DisagreeLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">確認請假資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("disagree_leave") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-12">
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="name" >姓名</label>
                                <div class="col-6">
                                    <input id='d_name' name="name" style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="category" >假別</label>
                                <div class="col-6">
                                    <input id='d_category' name="category" style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="reason" >原因</label>
                                <div class="col-6">
                                    <input id='d_reason' name="reason" style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="start" >開始時間</label>
                                <div class="col-6">
                                    <input id='d_start' name="start" style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="end" >結束時間</label>
                                <div class="col-6">
                                    <input id='d_end' name="end" style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-3 col-form-label" for="leave_time" >請假時長</label>
                                <div class="col-6">
                                    <input id='d_leave_time' name="leave_time" style="text-align: center"  type="text" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="form-group row">
                                <label style="text-align: right;" class="col-5 col-form-label" for="disagree" >請填寫不同意假單原因</label>
                                <div class="col-6">
                                    <input id='no' name="no" style="text-align: center"  type="hidden">
                                    <input id='disagree' name="disagree" style="text-align: center"  type="text" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    <script>
        // 確認假單資訊資料處理
        function check(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("name").value=jdata[jdata_index].name;
            document.getElementById("category").value=jdata[jdata_index].category;
            document.getElementById("reason").value=jdata[jdata_index].reason;
            document.getElementById("start").value=jdata[jdata_index].start;
            document.getElementById("end").value=jdata[jdata_index].end;
            document.getElementById("leave_time").value=jdata[jdata_index].leave_time;
            document.getElementById("leave_created").value=jdata[jdata_index].created;
        }
        //不同意資料處理
        function disagree(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("d_name").value=jdata[jdata_index].name;
            document.getElementById("d_category").value=jdata[jdata_index].category;
            document.getElementById("d_reason").value=jdata[jdata_index].reason;
            document.getElementById("d_start").value=jdata[jdata_index].start;
            document.getElementById("d_end").value=jdata[jdata_index].end;
            document.getElementById("d_leave_time").value=jdata[jdata_index].leave_time;
            document.getElementById("no").value=jdata[jdata_index].no;
        }
        {{--    取得已選取目標--}}
        function getIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.no
            })
        }
        function getLeaveSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.leave
            })
        }
        function getDepartSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.depart_leave_unit_department
            })
        }
        //審核1
        function post_check_status_1(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","0");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","0");
            form.appendChild(status3selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        //審核2
        function post_check_status_2(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","1");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","0");
            form.appendChild(status3selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        //審核3
        function post_check_status_3(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","1");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","1");
            form.appendChild(status3selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        //審核4
        function post_check_status_4(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","1");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","1");
            form.appendChild(status3selectionsField);
            var status4selectionsField = document.createElement("input");
            status4selectionsField.setAttribute("type", "hidden");
            status4selectionsField.setAttribute("name", "status4");
            status4selectionsField.setAttribute("value","1");
            form.appendChild(status4selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--表格設定(boostrap-tabel)--}}
    <script>
        // 載入資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        //動態載入表格之前，先銷燬表格
        $('#tableL01').bootstrapTable('destroy');
        //設定欄位標題
        if({{$check}}=="1")
        {
            var tableColumns = [
                {field: 'leave_off_work_no', title: '姓名', sortable: false},
                {field: 'signing_status_1', title: '審核1', sortable: false},
                {field: 'signing_status_2', title: '審核2', sortable: false},
                {field: 'signing_status_3', title: '審核3', sortable: false},
                {field: 'signing_status_4', title: '審核4', sortable: false},
                {field: 'disagree', title: '審核不通過', sortable: false},
            ];
        }
        else
        {
            var tableColumns = [
                {field: 'leave_off_work_no',title: '姓名', sortable: false},
                {field: 'signing_status_1', title: '審核1', sortable: false},
                {field: 'signing_status_2', title: '審核2', sortable: false},
                {field: 'signing_status_3', title: '審核3', sortable: false},
                {field: 'disagree',title: '審核不通過', sortable: false},
            ];
        }
        //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
    </script>
@endsection
